/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.AbstractPosAwarePrioritizedTask;
import com.ishland.c2me.base.common.scheduler.WrappingTask;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.class_1923;
import net.minecraft.class_8563;

public class SchedulingManager {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    public static final int MAX_LEVEL = class_8563.field_44849 + 1;
    private final ConcurrentMap<Long, FreeableTaskList> pos2Tasks = new ConcurrentHashMap<Long, FreeableTaskList>();
    private final Long2IntOpenHashMap prioritiesFromLevel = new Long2IntOpenHashMap(){

        protected void rehash(int newN) {
            if (this.n < newN) {
                super.rehash(newN);
            }
        }
    };
    private final StampedLock prioritiesLock = new StampedLock();
    private final int id = COUNTER.getAndIncrement();
    private volatile class_1923 currentSyncLoad = null;
    private boolean consolidatingLevelUpdates = false;
    private Queue<Runnable> consolidatedLevelUpdates = new ArrayDeque<Runnable>();
    private final Executor executor;

    public SchedulingManager(Executor executor) {
        this.prioritiesFromLevel.defaultReturnValue(MAX_LEVEL);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueue(AbstractPosAwarePrioritizedTask task) {
        while (true) {
            FreeableTaskList locks;
            long pos = task.getPos();
            FreeableTaskList freeableTaskList = locks = this.pos2Tasks.computeIfAbsent(pos, unused -> new FreeableTaskList());
            synchronized (freeableTaskList) {
                if (!locks.freed) {
                    locks.add(task);
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var5_4
                    task.setPriority(this.getPriority(pos));
                    task.addPostExec(() -> {
                        FreeableTaskList tasks = (FreeableTaskList)((Object)((Object)this.pos2Tasks.get(task.getPos())));
                        if (tasks != null) {
                            FreeableTaskList freeableTaskList = tasks;
                            synchronized (freeableTaskList) {
                                if (tasks.freed) {
                                    return;
                                }
                                tasks.remove(task);
                                if (tasks.isEmpty()) {
                                    tasks.freed = true;
                                }
                            }
                            if (tasks.freed) {
                                this.pos2Tasks.remove(task.getPos());
                            }
                        }
                    });
                    GlobalExecutors.prioritizedScheduler.schedule(task);
                    return;
                }
            }
        }
    }

    public void enqueue(long pos, Runnable command) {
        this.enqueue(new WrappingTask(pos, command));
    }

    public Executor positionedExecutor(long pos) {
        return command -> this.enqueue(pos, command);
    }

    public void updatePriorityFromLevel(long pos, int level) {
        this.executor.execute(() -> this.updatePriorityFromLevel0(pos, level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePriorityFromLevel0(long pos, int level) {
        if (this.getPriorityFromMap(pos) == level) {
            return;
        }
        long stamp = this.prioritiesLock.writeLock();
        try {
            if (level < MAX_LEVEL) {
                this.prioritiesFromLevel.put(pos, level);
            } else {
                this.prioritiesFromLevel.remove(pos);
            }
        }
        finally {
            this.prioritiesLock.unlockWrite(stamp);
        }
        this.updatePriorityInternal(pos);
    }

    public void updatePriorityFromLevelOnMain(long pos, int level) {
        if (this.consolidatingLevelUpdates) {
            this.consolidatedLevelUpdates.add(() -> this.updatePriorityFromLevel0(pos, level));
        } else {
            this.updatePriorityFromLevel(pos, level);
        }
    }

    public void setConsolidatingLevelUpdates(boolean value) {
        this.consolidatingLevelUpdates = value;
        if (!value && !this.consolidatedLevelUpdates.isEmpty()) {
            Queue<Runnable> runnables = this.consolidatedLevelUpdates;
            this.consolidatedLevelUpdates = new ArrayDeque<Runnable>();
            this.executor.execute(() -> {
                for (Runnable runnable : runnables) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePriorityInternal(long pos) {
        int priority = this.getPriority(pos);
        FreeableTaskList locks = (FreeableTaskList)((Object)this.pos2Tasks.get(pos));
        if (locks != null) {
            FreeableTaskList freeableTaskList = locks;
            synchronized (freeableTaskList) {
                if (locks.freed) {
                    return;
                }
                ObjectIterator objectIterator = locks.iterator();
                while (objectIterator.hasNext()) {
                    AbstractPosAwarePrioritizedTask lock = (AbstractPosAwarePrioritizedTask)objectIterator.next();
                    lock.setPriority(priority);
                    GlobalExecutors.prioritizedScheduler.notifyPriorityChange(lock);
                }
            }
        }
    }

    private int getPriority(long pos) {
        int chebyshevDistance;
        int fromLevel = this.getPriorityFromMap(pos);
        class_1923 currentSyncLoad1 = this.currentSyncLoad;
        int fromSyncLoad = currentSyncLoad1 != null ? ((chebyshevDistance = SchedulingManager.chebyshev(new class_1923(pos), currentSyncLoad1)) <= 8 ? chebyshevDistance : MAX_LEVEL) : MAX_LEVEL;
        return Math.min(fromLevel, fromSyncLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPriorityFromMap(long pos) {
        int fromLevel = MAX_LEVEL;
        long stamp = this.prioritiesLock.tryOptimisticRead();
        try {
            fromLevel = this.prioritiesFromLevel.get(pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.prioritiesLock.validate(stamp)) {
            stamp = this.prioritiesLock.readLock();
            try {
                fromLevel = this.prioritiesFromLevel.get(pos);
            }
            finally {
                this.prioritiesLock.unlockRead(stamp);
            }
        }
        return fromLevel;
    }

    public void setCurrentSyncLoad(class_1923 pos) {
        this.executor.execute(() -> {
            if (this.currentSyncLoad != null) {
                class_1923 lastSyncLoad = this.currentSyncLoad;
                this.currentSyncLoad = null;
                this.updateSyncLoadInternal(lastSyncLoad);
            }
            if (pos != null) {
                this.currentSyncLoad = pos;
                this.updateSyncLoadInternal(pos);
            }
        });
    }

    public int getId() {
        return this.id;
    }

    private void updateSyncLoadInternal(class_1923 pos) {
        long startTime = System.nanoTime();
        for (int xOff = -8; xOff <= 8; ++xOff) {
            for (int zOff = -8; zOff <= 8; ++zOff) {
                this.updatePriorityInternal(class_1923.method_8331((int)(pos.field_9181 + xOff), (int)(pos.field_9180 + zOff)));
            }
        }
        long endTime = System.nanoTime();
    }

    private static int chebyshev(class_1923 a, class_1923 b) {
        return Math.max(Math.abs(a.field_9181 - b.field_9181), Math.abs(a.field_9180 - b.field_9180));
    }

    private static int chebyshev(long a, long b) {
        return Math.max(Math.abs(class_1923.method_8325((long)a) - class_1923.method_8325((long)b)), Math.abs(class_1923.method_8332((long)a) - class_1923.method_8332((long)b)));
    }

    private static class FreeableTaskList
    extends ObjectArraySet<AbstractPosAwarePrioritizedTask> {
        private boolean freed = false;

        private FreeableTaskList() {
        }
    }
}

